/*
 * Decompiled with CFR 0.152.
 */
package com.kekie6.colorfulazaleas.util;

import com.kekie6.colorfulazaleas.ColorfulAzaleas;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class ColorfulTreeDecorator
extends TreeDecorator {
    public static final Codec<ColorfulTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122824_.m_194605_().fieldOf("leafBlock").forGetter(ColorfulTreeDecorator::getLeafBlock), (App)Registry.f_122824_.m_194605_().fieldOf("logBlock").forGetter(ColorfulTreeDecorator::getLogBlock)).apply((Applicative)instance, ColorfulTreeDecorator::new));
    public static final List<Direction> ACCEPTABLE_POS = List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
    public final Block leafBlock;
    public final Block logBlock;

    public ColorfulTreeDecorator(Block leafBlock, Block logBlock) {
        this.leafBlock = leafBlock;
        this.logBlock = logBlock;
    }

    public Block getLeafBlock() {
        return this.leafBlock;
    }

    public Block getLogBlock() {
        return this.logBlock;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return ColorfulAzaleas.COLORFUL_TREE_DECORATOR.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        List<BlockPos> leaves = context.m_226069_().stream().filter(blockPos -> context.m_226059_(blockPos.m_7495_())).toList();
        for (BlockPos leaf : leaves) {
            if (context.m_226067_().m_188501_() >= 0.4f) continue;
            int limit = context.m_226067_().m_216339_(2, 4);
            for (int i = 1; i <= limit; ++i) {
                BlockPos decoration = leaf.m_6625_(i).m_7949_();
                if (!context.m_226059_(decoration)) continue;
                context.m_226061_(decoration, this.getLeafBlock().m_49966_());
            }
        }
        ObjectArrayList logs = new ObjectArrayList((ObjectList)context.m_226068_());
        logs.sort(Comparator.comparingInt(Vec3i::m_123342_));
        Collections.reverse(logs);
        BlockPos bottomLog = (BlockPos)logs.stream().findFirst().orElseThrow();
        for (Direction acceptablePos : ACCEPTABLE_POS) {
            BlockPos placementPosition;
            if (context.m_226067_().m_188501_() >= 0.55f || !context.m_226059_(placementPosition = bottomLog.m_121945_(acceptablePos).m_7949_())) continue;
            context.m_226061_(placementPosition, this.getLogBlock().m_49966_());
        }
    }
}

